﻿using System;
using DataAccess;
using System.Collections.Generic;
using System.Data;

/// <summary>
//------------------------------------------------------------------
// This class implements the IQLogic COM object so that we do not
// have to go changing interfaces throughout the code -
//------------------------------------------------------------------
/// </summary>


public class CIQEngine
{
    private BaseMaster m_BaseMstr = null;
    public string m_strErrorMessage;

    private IQLogicLib.IIQLogicCOM m_iqLogic;
    public IQLogicLib.IIQLogicCOM GetIQLogic() { return m_iqLogic; }

    public int nJSON_FLAG_TYPE;
    public int nJSON_SCORE_TYPE;
    public int nJSON_PROB_TYPE;

    int nFLAG_TYPE = 10;
    int nPROBLEM_TYPE = 15;
    int nRESPONSE_TYPE = 20;
    int nLOGIC_TYPE = 30;

    const sbyte sbVarDelimit = 124; // | pipe character
    string strVarDelimit = "|";

    const sbyte sbLogicDelimit = 59; // ; semicolon
    string strLogicDelimit = ";";

    //------------------------------------------------------------------
    public CIQEngine(BaseMaster bmstr)
	{
        m_BaseMstr = bmstr;
        m_strErrorMessage = "";
        GetCOMLib();
	}

    //------------------------------------------------------------------
    private bool GetCOMLib()
    {
        m_iqLogic = new IQLogicLib.IQLogicCOMClass();
        if (m_iqLogic == null)
        {
            m_strErrorMessage = "GetCOMLib( ) - Unable to create the IQLogic COM component";
            return false;
        }
       
        //Load the data type definitions -
        nFLAG_TYPE      = m_iqLogic.GetFlagType();
        nPROBLEM_TYPE   = m_iqLogic.GetProblemType();
        nLOGIC_TYPE     = m_iqLogic.GetLogicType();
        nRESPONSE_TYPE  = m_iqLogic.GetResponseType();

        //Definitions for the type of retuned JSON
        nJSON_FLAG_TYPE = 20;// m_iqLogic.JSON_FLAG_TYPE();
        nJSON_SCORE_TYPE = 10;// m_iqLogic.JSON_SCORE_TYPE();
        nJSON_PROB_TYPE = 30;// m_iqLogic.JSON_PROB_TYPE();

        m_strErrorMessage = "";
        return true;
    }

    //------------------------------------------------------------------
    public bool AddSQLVarItem(DataSet dsLV)
    {
        if (dsLV != null) 
        {
            foreach (DataTable dt in dsLV.Tables) 
            {
                foreach (DataRow dr in dt.Rows) 
                {
                    string strVariableTYPE = Convert.ToString(nLOGIC_TYPE);

                    string strVariableName = String.Empty;
                    if (!dr.IsNull("identifier"))
                    {
                        strVariableName = dr["identifier"].ToString();
                    }
                    
                    string strVariableValue = String.Empty;
                    if(!dr.IsNull("var_value")){
                        strVariableValue = dr["var_value"].ToString();
                    }

                    string strKeyValue = strVariableTYPE + strVarDelimit + strVariableName + strVarDelimit + strVariableValue;

                    if (m_iqLogic != null)
                    {
                        m_iqLogic.Add(nLOGIC_TYPE, strKeyValue, sbVarDelimit);
                    }
                }
            }
        }

        return true;
    }

    //------------------------------------------------------------------
    public bool AddResponseVarItem(DataSet dsLV)
    {

        if (dsLV != null)
        {
            foreach (DataTable dt in dsLV.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    string strVariableTYPE = Convert.ToString(nRESPONSE_TYPE);

                    string strVariableTID = String.Empty;
                    if (!dr.IsNull("TID"))
                    {
                        strVariableTID = dr["TID"].ToString();
                    }

                    string strVariableQID = String.Empty;
                    if (!dr.IsNull("QID"))
                    {
                        strVariableQID = dr["QID"].ToString();
                    }

                    string strVariableRID = String.Empty;
                    if (!dr.IsNull("RID"))
                    {
                        strVariableRID = dr["RID"].ToString();
                    }

                    string strVariableName = String.Empty;
                    if (!dr.IsNull("IDENTIFIER"))
                    {
                        strVariableName = dr["IDENTIFIER"].ToString();
                    }

                    string strVariableValue = String.Empty;
                    if (!dr.IsNull("RESPONSE_VALUE"))
                    {
                        strVariableValue = dr["RESPONSE_VALUE"].ToString();
                    }

                    string strVariableScore = String.Empty;
                    if (!dr.IsNull("SCORE_VALUE"))
                    {
                        strVariableScore = dr["SCORE_VALUE"].ToString();
                    }

                    string strKeyValue = strVariableTYPE + strVarDelimit + strVariableTID + strVarDelimit + strVariableQID + strVarDelimit + strVariableRID + strVarDelimit + strVariableName + strVarDelimit + strVariableValue + strVarDelimit + strVariableScore;

                    if (m_iqLogic != null)
                    {
                        m_iqLogic.Add(nRESPONSE_TYPE, strKeyValue, sbVarDelimit);
                    }
                }
            }
        }

        return true;
    }
   
    //------------------------------------------------------------------
    public bool Calculate(string strEquation)
    {
        m_iqLogic.Calculate(strEquation, sbLogicDelimit);

        //Check for errors -
        int nError = m_iqLogic.GetErrorCode();
        if (nError < 0)
        {
            m_iqLogic.GetErrorDescription(nError, out m_strErrorMessage);
            return false;
        }

        return true;
    }

    //------------------------------------------------------------------
    public string GetJSon(int nType)
    {
        string strJason = "";
        m_iqLogic.GetJSon(nType, out strJason);
        return strJason;
    }

}